/** @type {import('next').NextConfig} */
const { withContentlayer } = require('next-contentlayer');

const isProd = process.env.NODE_ENV === 'production';

module.exports = withContentlayer({
  output: 'export',
  basePath: '/blog',
  images: { unoptimized: true },
  trailingSlash: true,
  reactStrictMode: true
});