import tags from '@/content/tags.json';

export function TagCloud() {
  const entries = Object.entries(tags as Record<string,string[]>)
    .sort((a,b)=> b[1].length - a[1].length)
    .slice(0, 12);

  return (
    <div className="tagcloud">
      {entries.map(([tag, slugs]) => (
        <a key={tag} className="tagchip" href={`/tags/${encodeURIComponent(tag)}/`}>
          {tag}<span className="tagchip-count">{slugs.length}</span>
        </a>
      ))}
    </div>
  );
}
