import { Post } from 'contentlayer/generated';
import { useMDXComponent } from 'next-contentlayer/hooks';

export function PostLayout({ post }: { post: Post }) {
  const MDX = useMDXComponent(post.body.code);
  return (
    <article>
      <h1>{post.title}</h1>
      <div style={{fontSize:12, opacity:0.7}}>{new Date(post.date).toLocaleDateString('ko-KR')}</div>
      <div style={{marginTop:16}}>
        <MDX />
      </div>
      <hr style={{margin:'24px 0'}} />
      <p><a href="https://link.coupang.com/a/cAK4KA">https://link.coupang.com/a/cAK4KA</a></p>
      <p><a href="https://cafe.naver.com/realcom7">https://cafe.naver.com/realcom7</a></p>
    </article>
  );
}