import Link from 'next/link';
import type { Post } from 'contentlayer/generated';

export function PostCard({ post }: { post: Post }) {
  return (
    <article className="card">
      <div className="card-body">
        <div className="card-meta">
          <span>{new Date(post.date).toLocaleDateString('ko-KR')}</span>
          {post.tags && post.tags.length ? (
            <span className="card-tags">{post.tags.slice(0,3).join(' · ')}</span>
          ) : null}
        </div>
        <h3 className="card-title">
          <Link href={`/posts/${post.slug}/`}>{post.title}</Link>
        </h3>
        {post.description ? <p className="card-desc">{post.description}</p> : null}
        <div className="card-cta">
          <Link className="btn btn--ghost" href={`/posts/${post.slug}/`}>자세히 보기 →</Link>
        </div>
      </div>
    </article>
  );
}
