import { allPosts } from 'contentlayer/generated';

export const dynamic = 'force-static';

export async function GET() {
  const base = 'https://realcom.kr/blog';
  const urls = allPosts.map(p => `<url><loc>${base}/posts/${p.slug}/</loc><lastmod>${new Date(p.date).toISOString()}</lastmod></url>`).join('\n');
  const xml = `<?xml version="1.0" encoding="UTF-8"?>\n<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">\n<url><loc>${base}/</loc></url>\n${urls}\n</urlset>`;
  return new Response(xml, { headers: { 'Content-Type': 'application/xml; charset=utf-8' } });
}