import { allPosts } from 'contentlayer/generated';

export const dynamic = 'force-static';

export async function GET() {
  const base = 'https://realcom.kr/blog';
  const items = allPosts.map(p => `
    <item>
      <title><![CDATA[${p.title}]]></title>
      <link>${base}/posts/${p.slug}/</link>
      <pubDate>${new Date(p.date).toUTCString()}</pubDate>
      <guid>${base}/posts/${p.slug}/</guid>
      <description><![CDATA[${p.description ?? ''}]]></description>
    </item>`).join('\n');
  const xml = `<?xml version="1.0" encoding="UTF-8"?>\n<rss version="2.0"><channel>\n<title>리얼컴 블로그</title>\n<link>${base}/</link>\n<description>리얼컴의 IT 블로그</description>\n${items}\n</channel></rss>`;
  return new Response(xml, { headers: { 'Content-Type': 'application/rss+xml; charset=utf-8' } });
}