import Link from 'next/link';
import { allPosts, Post } from 'contentlayer/generated';
import { PostCard } from '@/components/PostCard';
import { TagCloud } from '@/components/TagCloud';

export default function Page() {
  const posts = allPosts
    .sort((a: Post, b: Post) => +new Date(b.date) - +new Date(a.date));

  const latest = posts.slice(0, 6);
  const lastUpdated = posts.length ? new Date(posts[0].date) : null;

  return (
    <div className="container">
      <section className="hero">
        <div className="hero-left">
          <h1 className="hero-title">리얼컴 블로그</h1>
          <p className="hero-subtitle">
            조립PC · 윈도우 오류 해결 · NAS · 자동화 꿀팁을 한 곳에.
          </p>
          <div className="hero-cta">
            <a className="btn" href="https://cafe.naver.com/realcom7" target="_blank" rel="noopener noreferrer">네이버 카페</a>
            <a className="btn btn--ghost" href="/posts/">전체 글</a>
          </div>
          <div className="hero-stats">
            <div className="stat"><span className="stat-num">{posts.length}</span><span className="stat-label">게시글</span></div>
            <div className="stat"><span className="stat-num">{new Set(posts.flatMap(p=>p.tags||[])).size}</span><span className="stat-label">태그</span></div>
            <div className="stat"><span className="stat-num">{lastUpdated ? lastUpdated.toLocaleDateString('ko-KR') : '-'}</span><span className="stat-label">최근 업데이트</span></div>
          </div>
        </div>
        <div className="hero-right">
          <div className="hero-card">
            <h3>빠른 이동</h3>
            <ul className="quicklinks">
              {posts.slice(0,4).map((p)=> (
                <li key={p.slug}><Link href={`/posts/${p.slug}/`}>{p.title}</Link></li>
              ))}
            </ul>
            <h4>인기 태그</h4>
            <TagCloud />
          </div>
        </div>
      </section>

      <section className="section">
        <div className="section-head">
          <h2>최신 글</h2>
          <Link className="link" href="/posts/">모두 보기 →</Link>
        </div>
        <div className="grid">
          {latest.map((post)=> <PostCard key={post.slug} post={post}/>)}
        </div>
      </section>

      <section className="cta-banner">
        <div className="cta-text">
          <strong>조립 PC 상담 / 견적</strong>이 필요하시면 카페로 문의 주세요.
        </div>
        <a className="btn" href="https://cafe.naver.com/realcom7" target="_blank" rel="noopener noreferrer">바로가기</a>
      </section>
    </div>
  );
}
