import './globals.css';
import { NavBar } from '../components/NavBar';
import { Footer } from '../components/Footer';
import type { ReactNode } from 'react';

export const metadata = {
  title: '리얼컴 블로그 | 조립PC · 윈도우 팁 · 오류 해결',
  description: '리얼컴의 IT 노하우와 조립PC, 윈도우 문제 해결 방법을 한곳에 모았습니다.',
  metadataBase: new URL('https://realcom.kr')
};

export default function RootLayout({ children }: { children: ReactNode }) {
  return (
    <html lang="ko">
      <body style={{fontFamily:'system-ui, -apple-system, Segoe UI, Roboto, Apple SD Gothic Neo, Noto Sans KR, sans-serif'}}>
        <div style={{maxWidth: '960px', margin: '0 auto', padding: '24px'}}>
          <NavBar />
          <main style={{minHeight: '60vh'}}>{children}</main>
          <Footer />
        </div>
      </body>
    </html>
  );
}