import os
from modules.share import list_share

NGINX_WEBDAV_CONF = "/etc/nginx/conf.d/webdav_auto.conf"

def update_nginx_webdav_conf():
    """
    Samba 공유폴더 정보를 읽어서
    각 폴더별로 nginx WebDAV location 블록을 생성.
    guestok==True 면 인증 없이 공개, False면 WebDAV 로그인 강제.
    conf 변경 후 반드시 nginx reload 필요!
    """
    shares = list_share()
    blocks = []
    for s in shares:
        if not s['path'] or not s['name']:
            continue
        # guestok==True 면 인증 없음, 아니면 htpasswd 로그인 강제
        if s.get("guestok", False):
            auth_block = ""  # 인증 없이 공개
        else:
            auth_block = """
        auth_basic "WebDAV";
        auth_basic_user_file /etc/nginx/.htpasswd;
            """.rstrip()
        blocks.append(f"""
    location /{s['name']}/ {{
        alias {s['path'].rstrip('/')}/;
        dav_methods     PUT DELETE MKCOL COPY MOVE;
        dav_ext_methods PROPFIND OPTIONS;
        dav_access      user:rw group:rw all:r;
        {auth_block}
        client_max_body_size 2G;
        create_full_put_path on;
        autoindex on;
    }}
""")
    # 전체 server 블록
    full_conf = f"""
server {{
    listen 80;
    server_name _;
    charset utf-8;
{''.join(blocks)}
}}
""".lstrip()
    with open(NGINX_WEBDAV_CONF, "w") as f:
        f.write(full_conf)
    print(f"[WebDAV] nginx webdav conf 자동생성 완료 ({len(blocks)}개 location)")

# --- 아래는 예시 실행 코드 (실제 서비스에선 필요 없으면 생략) ---
if __name__ == "__main__":
    update_nginx_webdav_conf()
