import os
import subprocess

NGINX_CONF_PATH = "/etc/nginx/conf.d/webdav_auto.conf"
HTPASSWD_PATH = "/etc/nginx/.htpasswd"

def make_htpasswd(users):
    """users: [{"username":, "password":}, ...]"""
    tmpfile = "/tmp/.htpasswd_tmp"
    # 항상 새로 만듦
    if os.path.exists(tmpfile):
        os.remove(tmpfile)
    for idx, u in enumerate(users):
        if idx == 0:
            cmd = ["htpasswd", "-bc", tmpfile, u["username"], u["password"]]
        else:
            cmd = ["htpasswd", "-b", tmpfile, u["username"], u["password"]]
        subprocess.run(cmd, check=True)
    # cross-device 오류 방지: 직접 복사 후 삭제
    with open(tmpfile, "rb") as src, open(HTPASSWD_PATH, "wb") as dst:
        dst.write(src.read())
    os.remove(tmpfile)

def generate_webdav_conf(shares, default_share=None):
    """
    shares: list of dict (name/path)
    default_share: 대표폴더명 (없으면 루트 접근시 404)
    """
    lines = [
        "server {",
        "    listen 80;",
        "    server_name _;",
        "    charset utf-8;"
    ]
    # 1. / → 대표폴더 리다이렉트
    if default_share:
        lines.append(f'''
    location = / {{
        return 302 /{default_share}/;
    }}
''')
    # 2. 폴더별 WebDAV location
    for s in shares:
        url_path = f"/{s['name']}/"
        lines.append(f"    location {url_path} {{")
        lines.append(f"        alias {s['path'].rstrip('/')}/;")
        lines.append("        dav_methods     PUT DELETE MKCOL COPY MOVE;")
        lines.append("        dav_ext_methods PROPFIND OPTIONS;")
        lines.append("        dav_access      user:rw group:rw all:r;")
        # 인증 항상 걸기 (guestok이면 # 처리하고 싶으면 조건문)
        lines.append("        auth_basic \"WebDAV\";")
        lines.append("        auth_basic_user_file /etc/nginx/.htpasswd;")
        lines.append("        client_max_body_size 2G;")
        lines.append("        create_full_put_path on;")
        lines.append("        autoindex on;")
        lines.append("    }")
    lines.append("}")
    with open(NGINX_CONF_PATH, "w") as f:
        f.write("\n".join(lines))
    # 필요시 reload까지 자동
    os.system("sudo nginx -t && sudo systemctl reload nginx")
