import subprocess

def get_network_stats():
    # ifconfig 명령 결과를 간단히 파싱 (eth0, wlan0 등 인터페이스 기준)
    result = subprocess.run(["ifconfig"], capture_output=True, text=True)
    stats = {}
    current_iface = None
    for line in result.stdout.splitlines():
        if not line.startswith(' '):
            current_iface = line.split()[0]
            stats[current_iface] = {"RX": 0, "TX": 0}
        if "RX packets" in line:
            m = re.search(r"RX packets (\d+)", line)
            if m:
                stats[current_iface]["RX"] = int(m.group(1))
        if "TX packets" in line:
            m = re.search(r"TX packets (\d+)", line)
            if m:
                stats[current_iface]["TX"] = int(m.group(1))
    return stats
