# © Realcom. All rights reserved.
# This software is protected by copyright law.
# Unauthorized copying, modification, or redistribution is prohibited.
#
# 본 소프트웨어는 저작권법의 보호를 받습니다.
# 저작권자의 사전 서면 동의 없이
# 무단 사용, 복제, 수정, 재배포를 금지합니다.
#
# Use of this software constitutes acceptance of the above terms.
# 본 소프트웨어를 사용하는 행위는 위 조건에 동의한 것으로 간주됩니다.

import subprocess

SERVICES = ["smbd", "wireguard", "apache2"]

def check_service_status():
    statuses = {}
    for svc in SERVICES:
        try:
            result = subprocess.run(["systemctl", "is-active", svc], capture_output=True, text=True)
            statuses[svc] = result.stdout.strip()
        except Exception:
            statuses[svc] = "unknown"
    return statuses

def restart_service(service_name):
    try:
        subprocess.run(["sudo", "systemctl", "restart", service_name], check=True)
        return True
    except Exception:
        return False
