# © Realcom. All rights reserved.
# This software is protected by copyright law.
# Unauthorized copying, modification, or redistribution is prohibited.
#
# 본 소프트웨어는 저작권법의 보호를 받습니다.
# 저작권자의 사전 서면 동의 없이
# 무단 사용, 복제, 수정, 재배포를 금지합니다.
#
# Use of this software constitutes acceptance of the above terms.
# 본 소프트웨어를 사용하는 행위는 위 조건에 동의한 것으로 간주됩니다.

import subprocess

def get_network_stats():
    # ifconfig 명령 결과를 간단히 파싱 (eth0, wlan0 등 인터페이스 기준)
    result = subprocess.run(["ifconfig"], capture_output=True, text=True)
    stats = {}
    current_iface = None
    for line in result.stdout.splitlines():
        if not line.startswith(' '):
            current_iface = line.split()[0]
            stats[current_iface] = {"RX": 0, "TX": 0}
        if "RX packets" in line:
            m = re.search(r"RX packets (\d+)", line)
            if m:
                stats[current_iface]["RX"] = int(m.group(1))
        if "TX packets" in line:
            m = re.search(r"TX packets (\d+)", line)
            if m:
                stats[current_iface]["TX"] = int(m.group(1))
    return stats
