# 경로/파일: modules/run_policy.py
import argparse
import logging
import sys
import os

# ✅ app_dir 기준 경로로 맞춤
#   이 파일이 /opt/realcom-nas/realcom-nas-ui/modules/run_policy.py 라면
#   backup.py(또는 backup 패키지)도 modules 안에 있다는 전제 그대로 유지
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), ".")))

from backup import run_policy


def main():
    logging.basicConfig(
        # ✅ 로그 위치도 base_dir로 이동
        filename="/opt/realcom-nas/run_policy.log",
        level=logging.DEBUG,
        format="%(asctime)s %(levelname)s %(message)s",
    )

    parser = argparse.ArgumentParser(description="Run backup policy by ID")
    parser.add_argument("--id", required=True, help="Backup policy ID to run")
    args = parser.parse_args()

    logging.debug(f"run_policy.py 시작: 정책 ID={args.id}")

    result = run_policy(args.id)
    print(result)

    logging.debug(f"run_policy.py 종료: 결과={result}")


if __name__ == "__main__":
    main()
