# © Realcom. All rights reserved.
# This software is protected by copyright law.
# Unauthorized copying, modification, or redistribution is prohibited.
#
# 본 소프트웨어는 저작권법의 보호를 받습니다.
# 저작권자의 사전 서면 동의 없이
# 무단 사용, 복제, 수정, 재배포를 금지합니다.
#
# Use of this software constitutes acceptance of the above terms.
# 본 소프트웨어를 사용하는 행위는 위 조건에 동의한 것으로 간주됩니다.


import sys
import os
import logging

# --------------------------------------------------
# 기준 경로
# --------------------------------------------------
BASE_DIR = "/opt/realcom-nas"
APP_DIR = os.path.join(BASE_DIR, "realcom-nas-ui")
LOG_DIR = os.path.join(BASE_DIR, "logs")

os.makedirs(LOG_DIR, exist_ok=True)

# cron / shell 어디서 실행해도 modules import 보장
sys.path.insert(0, APP_DIR)

from modules.share import sync_samba_conf


def main():
    logging.basicConfig(
        filename=os.path.join(LOG_DIR, "sync_samba.log"),
        level=logging.INFO,
        format="%(asctime)s [%(levelname)s] %(message)s",
    )

    logging.info("sync_samba.py 시작")

    try:
        success = sync_samba_conf()
        if success:
            msg = "Samba 설정 동기화 및 서비스 재시작 완료"
            print(msg)
            logging.info(msg)
        else:
            msg = "Samba 설정 동기화 실패"
            print(msg)
            logging.error(msg)
            sys.exit(1)

    except Exception as e:
        logging.exception(f"sync_samba.py 실행 중 오류: {e}")
        print(f"ERROR: {e}")
        sys.exit(1)


if __name__ == "__main__":
    main()
