import subprocess

SERVICES = ["smbd", "wireguard", "apache2"]

def check_service_status():
    statuses = {}
    for svc in SERVICES:
        try:
            result = subprocess.run(["systemctl", "is-active", svc], capture_output=True, text=True)
            statuses[svc] = result.stdout.strip()
        except Exception:
            statuses[svc] = "unknown"
    return statuses

def restart_service(service_name):
    try:
        subprocess.run(["sudo", "systemctl", "restart", service_name], check=True)
        return True
    except Exception:
        return False
