<?php

error_reporting(0); // Set E_ALL for debugging

require './autoload.php';

// enable FTP connector netmount
elFinder::$netDrivers['ftp'] = 'FTP';

// Required for Dropbox network mount
// elFinder::$netDrivers['dropbox2'] = 'Dropbox2';

// Required for Google Drive network mount
// elFinder::$netDrivers['googledrive'] = 'GoogleDrive';

// Required for One Drive network mount
// elFinder::$netDrivers['onedrive'] = 'OneDrive';

// Required for Box network mount
// elFinder::$netDrivers['box'] = 'Box';

function logger($cmd, $result, $args, $elfinder, $volume) {
    $log = sprintf("[%s] %s: %s \n", date('Y-m-d H:i:s'), strtoupper($cmd), var_export($result, true));
    file_put_contents('./log.txt', $log, FILE_APPEND);
}

<?php

// 세션 시작
session_start();

// 접근 제어 함수 정의
function access($attr, $path, $data, $volume) {
    // 기본적으로 모든 사용자에게 접근 허용 (읽기 및 쓰기 모두 허용)
    return null;
}

// 파일 시스템 설정
$opts = array(
    'roots' => array(
        // 3T Disk 설정
        array(
            'driver'        => 'LocalFileSystem',
            'path'          => '/media/realcom/3T/',
            'URL'           => 'https://www.realcom.kr/3T/',
            'alias'         => '3T',
            'uploadDeny'    => array(),
            'uploadAllow'   => array('all'),
            'uploadOrder'   => array('deny', 'allow'),
            'accessControl' => 'access',
        ),
         // realser Disk 설정
         array(
            'driver'        => 'LocalFileSystem',
            'path'          => '/media/realcom/realser/',
            'URL'           => 'https://www.realcom.kr/realser/',
            'alias'         => 'realser',
            'uploadDeny'    => array(),
            'uploadAllow'   => array('all'),
            'uploadOrder'   => array('deny', 'allow'),
            'accessControl' => 'access',
        ),
        // 4T Disk 설정
        array(
            'driver'        => 'LocalFileSystem',
            'path'          => '/media/realcom/4T/',
            'URL'           => 'https://www.realcom.kr/4T/',
            'alias'         => '4T',
            'uploadDeny'    => array(),
            'uploadAllow'   => array('all'),
            'uploadOrder'   => array('deny', 'allow'),
            'accessControl' => 'access',
        ),
        // 4T_1 Disk 설정
        array(
            'driver'        => 'LocalFileSystem',
            'path'          => '/media/realcom/4T_1/',
            'URL'           => 'https://www.realcom.kr/4T_1/',
            'alias'         => '4T_1',
            'uploadDeny'    => array(),
            'uploadAllow'   => array('all'),
            'uploadOrder'   => array('deny', 'allow'),
            'accessControl' => 'access',
            
        ),
        array(
            'driver'        => 'Trash',
            'path'          => '/media/realcom/realser/files/.trash/',  // 휴지통 경로
            'tmbURL'        => dirname($_SERVER['PHP_SELF']) . '/../files/.trash/.tmb/',
            'winHashFix'    => DIRECTORY_SEPARATOR !== '/',
            'uploadDeny'    => array(),
            'uploadAllow'   => array('all'),
            'uploadOrder'   => array('deny', 'allow'),
            'accessControl' => 'access',
        ),
    ),
);



// elFinder 실행
$connector = new elFinderConnector(new elFinder($opts));
$connector->run();

?> 
