# © Realcom. All rights reserved.
# This software is protected by copyright law.
# Unauthorized copying, modification, or redistribution is prohibited.
#
# 본 소프트웨어는 저작권법의 보호를 받습니다.
# 저작권자의 사전 서면 동의 없이
# 무단 사용, 복제, 수정, 재배포를 금지합니다.
#
# Use of this software constitutes acceptance of the above terms.
# 본 소프트웨어를 사용하는 행위는 위 조건에 동의한 것으로 간주됩니다.

import argparse
import logging
import sys
import os


sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), ".")))

from backup import run_policy


def main():
    logging.basicConfig(
        # ✅ 로그 위치도 base_dir로 이동
        filename="/opt/realcom-nas/run_policy.log",
        level=logging.DEBUG,
        format="%(asctime)s %(levelname)s %(message)s",
    )

    parser = argparse.ArgumentParser(description="Run backup policy by ID")
    parser.add_argument("--id", required=True, help="Backup policy ID to run")
    args = parser.parse_args()

    logging.debug(f"run_policy.py 시작: 정책 ID={args.id}")

    result = run_policy(args.id)
    print(result)

    logging.debug(f"run_policy.py 종료: 결과={result}")


if __name__ == "__main__":
    main()
